def pdl_default_args(prob_type):
    defaults = {}
    defaults['lr'] = 1e-4
    defaults['batchsize'] = 200

    #if 'predopt' in prob_type:  # VDVF: default argument for feature Net ; since it is shared by both the acopf and qcqp prob
    #                            # , it might make sense its hyperparams here

    if 'predopt' in prob_type:  # VDVF: default argument for feature Net ; since it is shared by both the acopf and qcqp prob , it might make sense its hyperparams here
        defaults['featNet_nlayer'] = 1
        defaults['featNet_hiddensize'] = 50
        defaults['featsize'] = 50
        defaults['regressorNet_hidden_size'] = 200
        defaults['regressorNet_init'] = 'x'
        defaults['regressorNet_nlayer'] = 6
        defaults['regressorNet_dropout_rate'] = .2
        defaults['regressorNet_learning_rate'] = 1e-3
        defaults['regressorNet_optimizer'] = 1
    if prob_type == 'bilinear':
        defaults['nex'] = 4000
        defaults['nvar'] = 20
        defaults['nineq'] = 40
        defaults['neq'] = 2
        defaults['tau'] = 0.8
        defaults['rho'] = 0.5
        defaults['rhomax'] = 5000.
        defaults['alpha'] = 10.
        defaults['hiddensize'] = 500
        defaults['nlayer'] = 2
        defaults['epochs'] = 500
        defaults['maxouteriter'] = 10

    if prob_type in ['convexqp','nonconvexqp']:
        defaults['nex'] = 10000
        defaults['nvar'] = 100
        defaults['nineq'] = 50
        defaults['neq'] = 50
        defaults['tau'] = 0.8
        defaults['rho'] = 0.5
        defaults['rhomax'] = 5000.
        defaults['alpha'] = 10.
        defaults['hiddensize'] = 500
        defaults['nlayer'] = 2
        defaults['epochs'] = 500
        defaults['maxouteriter'] = 10
    elif prob_type in ['qcqp', 'predopt_qcqp'] :
        defaults['nvar'] = 50
        defaults['tau'] = 0.8
        defaults['rho'] = 1.
        defaults['rhomax'] = 10000.
        defaults['alpha'] = 1.5
        defaults['hiddensize'] = 500
        defaults['nlayer'] = 2
        defaults['maxinneriter'] = 5000
        defaults['maxouteriter'] = 10
        defaults['epochs'] = -1
    # JK from 'qcqp' case above
    elif 'knapsack' in prob_type :
        defaults['tau'] = 0.8
        defaults['rho'] = .5
        defaults['rhomax'] = 1000.
        defaults['alpha'] = 1.
        defaults['hiddensize'] = 250
        defaults['nlayer'] = 5
        #defaults['maxinneriter'] = 5000
        defaults['maxouteriter'] = 20
        defaults['epochs'] = 50 #-1
        defaults['normalize'] = True
        defaults['nex'] = 7000
        defaults['nvar'] = 30
        defaults['nineq'] = 1
        defaults['neq'] = 30
        defaults['lr'] = 1e-3

    elif 'acopf' in prob_type:
        '''
        defaults['tau'] = 0.9
        defaults['rho'] = 1.
        defaults['rhomax'] = 10000.
        defaults['alpha'] = 10.
        defaults['hiddenfrac'] = 1.2
        defaults['nlayer'] = 3
        defaults['epochs'] = 20
        defaults['maxouteriter'] = 10
        '''
        defaults['tau'] = 0.9
        defaults['rho'] = 1.
        defaults['rhomax'] = 10000.
        defaults['alpha'] = 10.
        defaults['hiddenfrac'] = 1.2
        defaults['nlayer'] = 4
        defaults['epochs'] = 200
        defaults['maxouteriter'] = 30

    elif 'portfolio_qcqp' in prob_type:
        defaults['nex'] = 6200
        defaults['tau'] = 0.7  # .8
        defaults['nvar'] = 50
        defaults['nineq'] = 50 + 1
        defaults['neq'] = 1
        defaults['rho'] = .5  # 1.
        defaults['use_sigmoid'] = False
        defaults['lambda'] = 2.
        defaults['normalize'] = False
        defaults['featsize'] = 50
        defaults['rhomax'] = 5000.  # 5000.
        defaults['alpha'] = 5  # 10.
        defaults['hiddenfrac'] = 4.0
        defaults['nlayer'] = 1
        defaults['epochs'] = 20  # 200
        defaults['maxouteriter'] = 20
        defaults['objscaler'] = 1.0
        defaults['batchsize'] = 50

    elif 'portfolio' in prob_type:
        '''
        defaults['nex'] = 12000
        defaults['tau'] = 0.8
        defaults['nvar'] = 50
        defaults['nineq'] = 50
        defaults['neq'] = 1
        defaults['rho'] = 1.
        defaults['rhomax'] = 5000.
        defaults['alpha'] = 10.
        defaults['use_sigmoid'] = False
        defaults['hiddenfrac'] = 4.0
        defaults['nlayer'] = 6
        defaults['epochs'] = 50
        defaults['maxouteriter'] = 10
        defaults['objscaler'] = 1.0
        defaults['batchsize'] = 50
        defaults['normalize'] = False
        '''
        defaults['nex'] = 12000
        defaults['tau'] = 0.7  # .8
        defaults['nvar'] = 50
        defaults['nineq'] = 50
        defaults['neq'] = 1
        defaults['rho'] = .5  # 1.
        defaults['use_sigmoid'] = False
        defaults['lambda'] = 2.
        defaults['normalize'] = False
        defaults['featsize'] = 50
        defaults['rhomax'] = 5000.  # 5000.
        defaults['alpha'] = 5  # 10.
        defaults['hiddenfrac'] = 4.0
        defaults['nlayer'] = 6
        defaults['epochs'] = 200  # 200
        defaults['maxouteriter'] = 20
        defaults['objscaler'] = 1.0
        defaults['batchsize'] = 50
        # defaults['lr'] = 1e-2
    else:
        raise NotImplementedError
    return defaults
    '''
    elif 'portfolio' in prob_type:
        defaults['tau'] = 0.9
        defaults['rho'] = 1.
        defaults['rhomax'] = 5000.
        defaults['alpha'] = 10.
        defaults['hiddenfrac'] = 4.0
        defaults['nlayer'] = 4
        defaults['epochs'] = 250
        defaults['maxouteriter'] = 10
        defaults['objscaler'] = 1.0
        #defaults['lr'] = 1e-2
    '''



def baseline_selfsupervised_default_args(prob_type):
    defaults = {}
    defaults['lr'] = 1e-4
    defaults['batchsize'] = 200
    if 'predopt' in prob_type:  # VDVF: default argument for feature Net ; since it is shared by both the acopf and qcqp prob
                                # , it might make sense its hyperparams here
        defaults['featNet_nlayer'] = 1
        defaults['featNet_hiddensize'] = 500
        defaults['featsize'] = 50
    if prob_type in ['convexqp','nonconvexqp']:
        defaults['nex'] = 10000
        defaults['nvar'] = 100
        defaults['nineq'] = 50
        defaults['neq'] = 50
        defaults['epochs'] = 10000
        defaults['lamg'] = 5.
        defaults['lamh'] = 5.
        defaults['hiddensize'] = 500
        defaults['nlayer'] = 2
    elif prob_type in ['qcqp']:
        defaults['nvar'] = 30
        defaults['maxiter'] = 100000
        defaults['lamg'] = 100.
        defaults['lamh'] = 100.
        defaults['hiddensize'] = 500
        defaults['nlayer'] = 2
    elif 'acopf' in prob_type:
        defaults['epochs'] = 5000
        defaults['lamg'] = 1.
        defaults['lamh'] = 1.
        defaults['hiddenfrac'] = 1.2
        defaults['nlayer'] = 2
    else:
        raise NotImplementedError
    return defaults


def baseline_supervised_default_args(prob_type, loss_type):
    defaults = {}
    defaults['lr'] = 1e-4
    defaults['batchsize'] = 200
    
    if 'acopf' in prob_type:
        defaults['lamg'] = 1.
        defaults['lamh'] = 1.
        defaults['lamu'] = 1.
        defaults['maxouteriter'] = 2
        defaults['ldupdatefreq'] = 50
        defaults['ldstepsize'] = 1.
        defaults['epochs'] = 20
        defaults['hiddenfrac'] = 1.2
        defaults['nlayer'] = 2
    else:
        raise NotImplementedError
    return defaults


def dc3_default_args(prob_type):
    defaults = {}
    defaults['lr'] = 1e-3 #1e-4
    defaults['batchsize'] = 200

    if 'predopt' in prob_type:  # VDVF: default argument for feature Net ; since it is shared by both the acopf and qcqp prob
        # , it might make sense its hyperparams here
        defaults['featNet_nlayer'] = 1
        defaults['featNet_hiddensize'] = 50
        defaults['featsize'] = 50
        #defaults['regressorNet_hidden_size'] = 200
        #defaults['regressorNet_init'] = 'x'
        #defaults['regressorNet_nlayer'] = 4
        #defaults['regressorNet_dropout_rate'] = .2
        #defaults['regressorNet_learning_rate'] = 1e-3
        #defaults['regressorNet_optimizer'] = 1

    if prob_type in ['convexqp','nonconvexqp']:
        defaults['nex'] = 2400
        defaults['nvar'] = 50
        defaults['nineq'] = 50
        defaults['neq'] = 50
        defaults['epochs'] = 1000
        defaults['hiddensize'] = 500
        defaults['softweight'] = 10          # use 100 if useCompl=False
        defaults['softweighteqfrac'] = 0.5
        defaults['usecompl'] = True
        defaults['usetraincorr'] = True
        defaults['usetestcorr'] = True
        defaults['corrmode'] = 'partial'    # use 'full' if useCompl=False
        defaults['corrtrainsteps'] = 10
        defaults['corrtestmaxsteps'] = 10
        defaults['correps'] = 1e-4
        defaults['corrlr'] = 1e-7
        defaults['corrmomentum'] = 0.5

    elif 'portfolio' in prob_type:
        '''
        defaults['nex'] = 12000
        defaults['maxouteriter'] = 100
        defaults['nvar'] = 50
        defaults['nineq'] = 50
        defaults['neq'] = 1
        defaults['seed'] = 1
        defaults['epochs'] = 200
        defaults['hiddensize'] = 500
        defaults['softweight'] = 10          # use 100 if useCompl=False
        defaults['softweighteqfrac'] = 0.5
        defaults['usecompl'] = True
        defaults['usetraincorr'] = True
        defaults['usetestcorr'] = True
        defaults['corrmode'] = 'partial'    # use 'full' if useCompl=False
        defaults['corrtrainsteps'] = 10
        defaults['corrtestmaxsteps'] = 10
        defaults['correps'] = 1e-4
        defaults['corrlr'] = 1e-7
        defaults['corrmomentum'] = 0.5
        defaults['use_sigmoid'] = False
        '''

        defaults['nex'] = 12000
        defaults['nvar'] = 50
        defaults['nineq'] = 50
        defaults['maxouteriter'] = 4
        defaults['lambda'] = 2.
        defaults['featsize'] = 50
        defaults['neq'] = 1
        defaults['epochs'] = 500
        defaults['hiddensize'] = 500
        defaults['softweight'] = 10  # use 100 if useCompl=False
        defaults['softweighteqfrac'] = 0.5
        defaults['use_sigmoid'] = False
        defaults['usecompl'] = True
        defaults['usetraincorr'] = True
        defaults['usetestcorr'] = True
        defaults['corrmode'] = 'partial'  # use 'full' if useCompl=False
        defaults['corrtrainsteps'] = 10
        defaults['corrtestmaxsteps'] = 10
        defaults['correps'] = 1e-4
        defaults['corrlr'] = 1e-7
        defaults['corrmomentum'] = 0.5
    elif 'acopf' in prob_type:
        raise NotImplementedError
    else:
        raise NotImplementedError
    return defaults

